package edu.uky.ai.lp.logic;

import java.util.ArrayList;

/**
 * A knowledge base is a collection of facts and rules that describe a logical
 * universe.
 * 
 * @author Stephen G. Ware
 */
public class KnowledgeBase {

	/** All the rules in this knowledge base */
	public final Iterable<Rule> rules = new ArrayList<>();

	/** All the facts in this knowledge base */
	public final Iterable<Fact> facts = new ArrayList<>();
	
	/**
	 * Constructs a new knowledge base with the given rules and facts.
	 * 
	 * @param rules the rules
	 * @param facts the facts
	 */
	public KnowledgeBase(Rule[] rules, Fact[] facts) {
		for(Rule rule : rules)
			addRule(rule);
		for(Fact fact : facts)
			addFact(fact);
	}
	
	@Override
	public String toString() {
		String str = "";
		for(Rule rule : rules)
			str += rule + "\n";
		for(Fact fact : facts)
			str += fact + ".\n";
		return str.trim();
	}
	
	/**
	 * Adds a new rule to the knowledge base.
	 * 
	 * @param rule the rule to add
	 */
	public void addRule(Rule rule) {
		((ArrayList<Rule>) rules).add(rule);
	}
	
	/**
	 * Adds a new fact to the knowledge base.
	 * 
	 * @param fact the fact to add
	 */
	public void addFact(Fact fact) {
		((ArrayList<Fact>) facts).add(fact);
	}
}
